Imports System.IO

Public Class FrmAPlusQuizGenerator
    Inherits System.Windows.Forms.Form

    Dim MyQuestion As QuizQuestion()
    Dim randomObject As Random = New Random
    Dim QuestionCounter As Integer
    Dim CorrectAnswerCounter As Integer
    Dim UserGuess As String()

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents panAnswers As System.Windows.Forms.Panel
    Friend WithEvents rdbAnswer1 As System.Windows.Forms.RadioButton
    Friend WithEvents rdbAnswer2 As System.Windows.Forms.RadioButton
    Friend WithEvents rdbAnswer3 As System.Windows.Forms.RadioButton
    Friend WithEvents rdbAnswer4 As System.Windows.Forms.RadioButton
    Friend WithEvents btnNext As System.Windows.Forms.Button
    Friend WithEvents lblQuestion As System.Windows.Forms.Label
    Friend WithEvents btnPrev As System.Windows.Forms.Button
    Friend WithEvents btnCheck As System.Windows.Forms.Button
    Friend WithEvents lblResult As System.Windows.Forms.Label
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents txtName As System.Windows.Forms.TextBox
    Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
    Friend WithEvents Timer1 As System.Windows.Forms.Timer
    Friend WithEvents txtTimer As System.Windows.Forms.TextBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.panAnswers = New System.Windows.Forms.Panel
        Me.rdbAnswer4 = New System.Windows.Forms.RadioButton
        Me.rdbAnswer3 = New System.Windows.Forms.RadioButton
        Me.rdbAnswer2 = New System.Windows.Forms.RadioButton
        Me.rdbAnswer1 = New System.Windows.Forms.RadioButton
        Me.btnNext = New System.Windows.Forms.Button
        Me.lblQuestion = New System.Windows.Forms.Label
        Me.btnPrev = New System.Windows.Forms.Button
        Me.btnCheck = New System.Windows.Forms.Button
        Me.lblResult = New System.Windows.Forms.Label
        Me.Label1 = New System.Windows.Forms.Label
        Me.txtName = New System.Windows.Forms.TextBox
        Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
        Me.Timer1 = New System.Windows.Forms.Timer(Me.components)
        Me.txtTimer = New System.Windows.Forms.TextBox
        Me.panAnswers.SuspendLayout()
        Me.SuspendLayout()
        '
        'panAnswers
        '
        Me.panAnswers.Controls.Add(Me.rdbAnswer4)
        Me.panAnswers.Controls.Add(Me.rdbAnswer3)
        Me.panAnswers.Controls.Add(Me.rdbAnswer2)
        Me.panAnswers.Controls.Add(Me.rdbAnswer1)
        Me.panAnswers.Location = New System.Drawing.Point(16, 200)
        Me.panAnswers.Name = "panAnswers"
        Me.panAnswers.Size = New System.Drawing.Size(392, 304)
        Me.panAnswers.TabIndex = 0
        '
        'rdbAnswer4
        '
        Me.rdbAnswer4.Location = New System.Drawing.Point(12, 232)
        Me.rdbAnswer4.Name = "rdbAnswer4"
        Me.rdbAnswer4.Size = New System.Drawing.Size(368, 64)
        Me.rdbAnswer4.TabIndex = 3
        '
        'rdbAnswer3
        '
        Me.rdbAnswer3.Location = New System.Drawing.Point(12, 160)
        Me.rdbAnswer3.Name = "rdbAnswer3"
        Me.rdbAnswer3.Size = New System.Drawing.Size(368, 64)
        Me.rdbAnswer3.TabIndex = 2
        '
        'rdbAnswer2
        '
        Me.rdbAnswer2.Location = New System.Drawing.Point(12, 88)
        Me.rdbAnswer2.Name = "rdbAnswer2"
        Me.rdbAnswer2.Size = New System.Drawing.Size(368, 64)
        Me.rdbAnswer2.TabIndex = 1
        '
        'rdbAnswer1
        '
        Me.rdbAnswer1.Location = New System.Drawing.Point(16, 16)
        Me.rdbAnswer1.Name = "rdbAnswer1"
        Me.rdbAnswer1.Size = New System.Drawing.Size(368, 64)
        Me.rdbAnswer1.TabIndex = 0
        '
        'btnNext
        '
        Me.btnNext.Location = New System.Drawing.Point(296, 520)
        Me.btnNext.Name = "btnNext"
        Me.btnNext.Size = New System.Drawing.Size(112, 40)
        Me.btnNext.TabIndex = 1
        Me.btnNext.Text = "Start"
        '
        'lblQuestion
        '
        Me.lblQuestion.Location = New System.Drawing.Point(16, 48)
        Me.lblQuestion.Name = "lblQuestion"
        Me.lblQuestion.Size = New System.Drawing.Size(392, 144)
        Me.lblQuestion.TabIndex = 2
        '
        'btnPrev
        '
        Me.btnPrev.Enabled = False
        Me.btnPrev.Location = New System.Drawing.Point(16, 520)
        Me.btnPrev.Name = "btnPrev"
        Me.btnPrev.Size = New System.Drawing.Size(112, 40)
        Me.btnPrev.TabIndex = 3
        Me.btnPrev.Text = "Previous"
        '
        'btnCheck
        '
        Me.btnCheck.Enabled = False
        Me.btnCheck.Location = New System.Drawing.Point(156, 520)
        Me.btnCheck.Name = "btnCheck"
        Me.btnCheck.Size = New System.Drawing.Size(112, 40)
        Me.btnCheck.TabIndex = 4
        Me.btnCheck.Text = "Check"
        '
        'lblResult
        '
        Me.lblResult.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lblResult.Location = New System.Drawing.Point(16, 584)
        Me.lblResult.Name = "lblResult"
        Me.lblResult.Size = New System.Drawing.Size(392, 64)
        Me.lblResult.TabIndex = 5
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(16, 8)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(64, 24)
        Me.Label1.TabIndex = 6
        Me.Label1.Text = "Name:"
        '
        'txtName
        '
        Me.txtName.Location = New System.Drawing.Point(88, 8)
        Me.txtName.Name = "txtName"
        Me.txtName.Size = New System.Drawing.Size(160, 26)
        Me.txtName.TabIndex = 7
        Me.txtName.Text = ""
        '
        'Timer1
        '
        Me.Timer1.Interval = 1000
        '
        'txtTimer
        '
        Me.txtTimer.Location = New System.Drawing.Point(320, 8)
        Me.txtTimer.Name = "txtTimer"
        Me.txtTimer.Size = New System.Drawing.Size(64, 26)
        Me.txtTimer.TabIndex = 8
        Me.txtTimer.Text = "0"
        Me.txtTimer.TextAlign = System.Windows.Forms.HorizontalAlignment.Right
        '
        'FrmAPlusQuizGenerator
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(8, 19)
        Me.BackColor = System.Drawing.Color.LightSteelBlue
        Me.ClientSize = New System.Drawing.Size(432, 661)
        Me.Controls.Add(Me.txtTimer)
        Me.Controls.Add(Me.txtName)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.lblResult)
        Me.Controls.Add(Me.btnCheck)
        Me.Controls.Add(Me.btnPrev)
        Me.Controls.Add(Me.lblQuestion)
        Me.Controls.Add(Me.btnNext)
        Me.Controls.Add(Me.panAnswers)
        Me.Font = New System.Drawing.Font("Microsoft Sans Serif", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Name = "FrmAPlusQuizGenerator"
        Me.Text = "A+ Quiz "
        Me.panAnswers.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub FrmAPlusQuizGenerator_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim MyStreamReader As StreamReader = New StreamReader(Directory.GetCurrentDirectory & "\ReviewQuestions.csv")
        Dim AllInfo As String
        Dim QuestionLine As String()
        Dim Token As String()
        Dim i As Integer
        Dim j As Integer
        Dim SwapQuestion As QuizQuestion

        AllInfo = MyStreamReader.ReadToEnd
        MyStreamReader.Close()

        QuestionLine = AllInfo.Trim.Split(vbCr)
        MyQuestion = New QuizQuestion(QuestionLine.GetUpperBound(0)) {}
        UserGuess = New String(QuestionLine.GetUpperBound(0)) {}

        For i = 0 To MyQuestion.GetUpperBound(0)
            Token = QuestionLine(i).Trim.Split(",")
            MyQuestion(i) = New QuizQuestion(i)
            MyQuestion(i).Question = Token(0)
            MyQuestion(i).CorrectAnswer = Token(1)
            For j = 0 To MyQuestion(i).AnswerCount - 1
                MyQuestion(i).PossibleAnswer(j) = Token(j + 1)
            Next j
            UserGuess(i) = ""

        Next i

        For i = 0 To MyQuestion.GetUpperBound(0)
            j = randomObject.Next(MyQuestion.GetLength(0))
            SwapQuestion = MyQuestion(i)
            MyQuestion(i) = MyQuestion(j)
            MyQuestion(j) = SwapQuestion
        Next

        lblQuestion.Text = "Quick on the Start button below to begin the quiz."
        QuestionCounter = -1
    End Sub

    Private Sub btnNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNext.Click
        Dim i As Integer
        Dim MyRadioButton As RadioButton

        If QuestionCounter < 0 Then
            Timer1.Enabled = True
            btnNext.Text = "Next"
        ElseIf QuestionCounter < 1 Then
            btnPrev.Enabled = True
            'start timer
        ElseIf QuestionCounter < MyQuestion.GetUpperBound(0) Then
            'regular question 
        Else
            'out of questions 
            lblQuestion.Text = "No more questions.  You can use the Previous button to review your answers or click the Check button to score your quiz."
            btnNext.Enabled = False
            btnCheck.Enabled = True
            For i = 0 To MyQuestion(QuestionCounter).AnswerCount - 1
                MyRadioButton = CType(panAnswers.Controls.Item(i), RadioButton)
                MyRadioButton.Text = ""

            Next

            Exit Sub
        End If

        QuestionCounter += 1
        lblQuestion.Text = MyQuestion(QuestionCounter).Question



        If UserGuess(QuestionCounter) = "" Then
            MyQuestion(QuestionCounter).ShufflePossibleAnswers()
        End If

        For i = 0 To MyQuestion(QuestionCounter).AnswerCount - 1
            MyRadioButton = CType(panAnswers.Controls.Item(i), RadioButton)
            MyRadioButton.Text = MyQuestion(QuestionCounter).PossibleAnswer(i)
            If UserGuess(QuestionCounter) = MyRadioButton.Text Then
                MyRadioButton.Checked = True
            Else
                MyRadioButton.Checked = False
            End If

        Next


    End Sub

    
    Private Sub rdbAnswer1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles rdbAnswer1.Click, rdbAnswer2.Click, rdbAnswer3.Click, rdbAnswer4.Click
        UserGuess(QuestionCounter) = sender.text
    End Sub

    Private Sub btnPrev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrev.Click
        Dim i As Integer
        Dim MyRadioButton As RadioButton

        btnNext.Enabled = True


        If QuestionCounter < 2 Then
            btnPrev.Enabled = False
            'start timer
        ElseIf QuestionCounter < MyQuestion.GetUpperBound(0) - 1 Then
            'check answer
        Else

        End If



        QuestionCounter -= 1
        lblQuestion.Text = MyQuestion(QuestionCounter).Question

        For i = 0 To MyQuestion(QuestionCounter).AnswerCount - 1
            MyRadioButton = CType(panAnswers.Controls.Item(i), RadioButton)
            MyRadioButton.Text = MyQuestion(QuestionCounter).PossibleAnswer(i)
            If UserGuess(QuestionCounter) = MyRadioButton.Text Then
                MyRadioButton.Checked = True
            Else
                MyRadioButton.Checked = False
            End If
        Next

    End Sub

    Private Sub btnCheck_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCheck.Click
        Dim i As Integer
        Dim j As Integer
        Dim MyStreamwriter As StreamWriter

        Timer1.Enabled = False

        MsgBox("Select a name and location for saving your results. Use a .txt extension.")

        SaveFileDialog1.ShowDialog()
        MyStreamwriter = New StreamWriter(SaveFileDialog1.FileName)


        For i = 0 To MyQuestion.GetUpperBound(0)
            If MyQuestion(i).CorrectAnswer = UserGuess(i) Then
                CorrectAnswerCounter += 1
            End If
        Next


        lblResult.Text = "You got " & CorrectAnswerCounter & " correct out of " & MyQuestion.GetLength(0)

        MyStreamwriter.WriteLine(Now.ToLongDateString & " " & Now.ToShortTimeString)
        MyStreamwriter.WriteLine(txtName.Text)
        MyStreamwriter.WriteLine(lblResult.Text)
        MyStreamwriter.WriteLine("Time: " & txtTimer.Text & " seconds.")
        MyStreamwriter.WriteLine()
        MyStreamwriter.WriteLine("Answers to questions you got wrong.")
        MyStreamwriter.WriteLine()

        For i = 0 To MyQuestion.GetUpperBound(0)
            If MyQuestion(i).CorrectAnswer = UserGuess(i) Then
                CorrectAnswerCounter += 1
            Else
                MyStreamwriter.WriteLine(MyQuestion(i).Question)
                MyStreamwriter.Write("Choices: ")
                For j = 0 To MyQuestion(i).AnswerCount - 1
                    MyStreamwriter.Write(MyQuestion(i).PossibleAnswer(j) & "   ")
                Next
                MyStreamwriter.WriteLine()
                MyStreamwriter.WriteLine("ANSWER: " & MyQuestion(i).CorrectAnswer)
                MyStreamwriter.WriteLine()
                MyStreamwriter.Flush()
            End If
        Next

        MyStreamwriter.Close()

    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        txtTimer.Text = CInt(txtTimer.Text) + 1
    End Sub
End Class
